# PDF Editor - Android App

Мобильное приложение для создания, редактирования и обмена PDF файлами на Android.

## Возможности

- ✅ Создание PDF из текста
- ✅ Добавление изображений в PDF
- ✅ Сохранение PDF файлов
- ✅ Обмен PDF через различные приложения
- ✅ Современный Material Design интерфейс
- ✅ Поддержка Android 5.0+ (API 21+)

## Сборка проекта

### Требования

- Android Studio Arctic Fox или новее
- Android SDK 34
- Java 8+
- Gradle 8.0+

### Инструкции по сборке

1. Откройте проект в Android Studio
2. Синхронизируйте Gradle файлы
3. Соберите проект: `Build > Make Project`
4. Создайте APK: `Build > Build Bundle(s) / APK(s) > Build APK(s)`

### Сборка через командную строку

```bash
# Сборка debug APK
./gradlew assembleDebug

# Сборка release APK
./gradlew assembleRelease
```

## Разрешения

Приложение запрашивает следующие разрешения:

- `READ_EXTERNAL_STORAGE` - для чтения изображений
- `WRITE_EXTERNAL_STORAGE` - для сохранения PDF файлов
- `CAMERA` - для сканирования документов (будущая функция)
- `INTERNET` - для обмена файлами

## Структура проекта

```
android_app/
├── app/
│   ├── src/main/
│   │   ├── java/com/arisweb/pdfeditor/
│   │   │   └── MainActivity.java
│   │   ├── res/
│   │   │   ├── layout/
│   │   │   ├── values/
│   │   │   ├── drawable/
│   │   │   └── mipmap-*/
│   │   └── AndroidManifest.xml
│   ├── build.gradle
│   └── proguard-rules.pro
├── gradle/
├── build.gradle
├── settings.gradle
└── gradle.properties
```

## Используемые библиотеки

- AndroidX AppCompat
- Material Design Components
- iText7 для работы с PDF
- Android PDF Viewer
- Glide для работы с изображениями
- Dexter для управления разрешениями

## Разработчик

Создано [Arisweb.ru](https://arisweb.ru) - профессиональная разработка веб и мобильных приложений.

## Лицензия

Этот проект создан для демонстрационных целей.